window.onload = function () {
  const mp3Player = document.querySelector(".main_div");
  const snakeGame = document.querySelector(".game-container");
  

  mp3Player.addEventListener("click", function () {
      mp3Player.style.zIndex = 2;
      snakeGame.style.zIndex = 1;
  });

  snakeGame.addEventListener("click", function () {
      mp3Player.style.zIndex = 1;
      snakeGame.style.zIndex = 2;
      refreshCanvas();
  });

  snakeGame.style.zIndex = 2;

    const canvasWidth = 480;
    const canvasHeight = 480;
    const blockSize = 15; // en pixels
    const canvas = document.createElement("canvas");
    const ctx = canvas.getContext('2d');
    const widthInBlocks = canvasWidth/blockSize; 
    const heightInBlocks = canvasHeight/blockSize;
    const centreX = canvasWidth / 2;
    const centreY = canvasHeight / 2;
    let delay; // en millisecondes
    let snakee;
    let applee;
    let score;
    let timeout;
  
    init();
    

    function init(){
      canvas.width = canvasWidth;
      canvas.height = canvasHeight;
      canvas.style.display = "block";
      canvas.style.backgroundColor = "#fff";
      document.querySelector(".game-container").appendChild(canvas);
      launch();
      
    }
  
    function launch(){
      snakee = new Snake([[6,4],[5,4],[4,4],[3,4],[2,4]], "right");
      applee = new Apple([10, 10]);
      score = 0;
      clearTimeout(timeout);
      delay = 100;
      refreshCanvas();
    }
  
    function refreshCanvas(){
      snakee.advance();
      if(snakee.checkCollision()){
        gameOver();
      } else {
        if(snakee.isEatingApple(applee)) {
          score++;
          snakee.ateApple = true;
          do {
            applee.setNewPosition();
          } while(applee.isOnSnake(snakee))
            if(score % 2 == 0){
              speedUp();
            }
        }
        ctx.clearRect(0,0,canvasWidth, canvasHeight);
        drawScore();
        snakee.draw();
        applee.draw();
        if(snakeGame.style.zIndex ==2) timeout = setTimeout(refreshCanvas, delay);
      }
    }
  
    function gameOver(){
      ctx.save();
      ctx.font = "bold 50px Verdana";
      ctx.fillStyle = "black";
      ctx.textAlign = "center";
      ctx.textBaseline = "middle";
      ctx.strokeStyle = "white";
      ctx.lineWidth = "5";
      ctx.strokeText("Game Over", centreX, centreY - 180);
      ctx.fillText("Game Over", centreX, centreY - 180);
      ctx.font = "bold 20px Verdana";
      ctx.strokeText("Press the spacebar to restart", centreX, centreY - 120);
      ctx.fillText("Press the spacebar to restart", centreX, centreY - 120);
      ctx.restore();
      saveScore(prompt("Entrez votre nom (5 lettres max)").slice(0,5),score); // Enregistrer le score actuel
  displayHighScores(); // Mettre à jour l'affichage des meilleurs scores
    }
  
    // Fonction pour enregistrer le score dans le stockage local
function saveScore(nom, score) {
  let highScores = JSON.parse(localStorage.getItem('snakeHighScoresV2')) || [];
  highScores.push({"nom":nom,"value":score});
  highScores.sort((a, b) => b.value - a.value); // Trie les scores par ordre décroissant
  highScores = highScores.slice(0, 3); // Garde seulement les 3 meilleurs scores
  localStorage.setItem('snakeHighScoresV2', JSON.stringify(highScores));
}

// Fonction pour afficher les meilleurs scores
function displayHighScores() {
  let highScores = JSON.parse(localStorage.getItem('snakeHighScoresV2')) || [];
  let recordList = document.getElementById('recordList');
  recordList.innerHTML = ''; // Efface les anciens scores
  highScores.forEach((score, index) => {
    let listItem = document.createElement('li');
    listItem.textContent = `#${index + 1}: ${score.nom} ${score.value}`;
    recordList.appendChild(listItem);
  });
}

    function drawScore(){
      ctx.save();
      ctx.font = "bold 200px Verdana";
      ctx.fillStyle = "gray";
      ctx.textAlign = "center";
      ctx.textBaseline = "middle";
      ctx.fillText(score.toString(), centreX, centreY);
      ctx.restore();
    }
  
    function speedUp(){
      delay /= 1.1;
    }
  
    //Fonction de dessin d'un block du serpent
    function drawBlock(ctx, position){
      const x = position[0] * blockSize;
      const y = position[1] * blockSize;
      ctx.fillRect(x, y, blockSize, blockSize);
    }
  
    //Fonction constructrice du serpent
    function Snake(body, direction){
      this.body = body;
      this.direction = direction;
      this.ateApple = false;
      this.draw = function(){
        ctx.save();
        ctx.fillStyle = "#11c25f";
        for(let i = 0; i < this.body.length;i++){
          drawBlock(ctx, this.body[i]);
        }
        ctx.restore();
      };
      this.advance = function(){
        const nextPosition = this.body[0].slice();
        switch(this.direction){
          case "left":
            nextPosition[0] -= 1;
            break;
          case "right":
            nextPosition[0] += 1;
            break;
          case "down":
            nextPosition[1] += 1;
            break;
          case "up":
            nextPosition[1] -= 1;
            break;
          default:
            throw("Invalid direction");
        }
        this.body.unshift(nextPosition);
        if(!this.ateApple)
          this.body.pop();
        else
          this.ateApple = false;
      };
      
      this.setDirection = function(newDirection){
        let allowedDirections;
        switch(this.direction){
          case "left":
          case "right":
            allowedDirections = ["up", "down"];
            break;
          case "down":
          case "up":
            allowedDirections = ["left", "right"];
            break;
          default:
            throw("Invalid direction");
        }
        if(allowedDirections.indexOf(newDirection) > -1){
          this.direction = newDirection;
        }
      };
      this.checkCollision = function(){
        let wallCollision = false;
        let snakeCollision = false;
        const head = this.body[0];
        const rest = this.body.slice(1);
        const snakeX = head[0];
        const snakeY = head[1];
        const minX = 0;
        const minY = 0;
        const maxX = widthInBlocks-1;
        const maxY = heightInBlocks-1;
        const isNotBetweenHorizontalWalls = snakeX < minX || snakeX > maxX;
        const isNotBetweenVerticalWalls = snakeY < minY || snakeY > maxY;
        if(isNotBetweenHorizontalWalls || isNotBetweenVerticalWalls){
          wallCollision = true;
        }
        for(let i = 0;i < rest.length;i++){
          if(snakeX == rest[i][0] && snakeY == rest[i][1]){
            snakeCollision = true;
          }
        }
        return wallCollision || snakeCollision;
      };
      this.isEatingApple = function(appleToEat){
        const head = this.body[0];
        if(head[0] === appleToEat.position[0] && head[1] === appleToEat.position[1])
          return true;
        else
          return false;
      };
    }
  
    //Fonction constructrice de la pomme
    function Apple(position){
      this.position = position;
      this.draw = function(){
        const radius = blockSize / 2;
        const x = this.position[0] * blockSize + radius;
        const y = this.position[1] * blockSize + radius;
        ctx.save();
        ctx.fillStyle = "#cc2222";
        ctx.beginPath();
        ctx.arc(x,y, radius, 0, Math.PI*2, true);
        ctx.fill();
        ctx.restore();
      };
      this.setNewPosition = function(){
        const newX = Math.round(Math.random() * (widthInBlocks - 1));
        const newY = Math.round(Math.random() * (heightInBlocks - 1));
        this.position = [newX,newY];
      };
      this.isOnSnake = function(snakeToCheck){
        let isOnSnake = false;
        for(let i = 0;i < snakeToCheck.body.length;i++){
          if(this.position[0] === snakeToCheck.body[i][0] && this.position[1] === snakeToCheck.body[i][1]){
            isOnSnake = true;
          }
        }
        return isOnSnake;
      };
    }
  
  
    //Gestion des touches du clavier
    /*
    document.onkeydown = function handleKeyDown(e){
      const key = e.keyCode;
      let newDirection;
      switch(key){
        case 37:
          newDirection = "left";
          break;
        case 38:
          newDirection = "up";
          break;
        case 39:
          newDirection = "right";
          break;
        case 40:
          newDirection = "down";
          break;
        case 32:
          restart();
          return;
        default:
          return;
      }
      snakee.setDirection(newDirection);
    }
    */
  
  
    const map = {}; // You could also use an array
    onkeydown = onkeyup = function(e){
      e = e || event; // to deal with IE
      map[e.keyCode] = e.type == 'keydown';
      let newDirection;
      console.log(map);
      if(map[37]){
        newDirection = "left";
      } else if(map[38]){
        newDirection = "up";
      } else if(map[39]){
        newDirection = "right";
      } else if(map[40]){
        newDirection = "down";
      } else if(map[32]){
        launch();
      }
      snakee.setDirection(newDirection);
    }
  
    window.addEventListener('keydown', onkeyup);
  window.addEventListener('keyup', onkeydown);
  }


  //getting all elements of html in js
let song_image = document.getElementById("cover_photo")
let song_title = document.getElementById("title")
let song_singer = document.getElementById("singer")
let song_play = document.getElementById("play")
let song_prev = document.getElementById("prev")
let song_next = document.getElementById("next")
 
 
 
console.log(song_play)
 
 
//creating song object list
let songs_list = [
    {
        name : 'Lay All Your Love On Me',
        Image : 'images/abba.jpg',
        Song : 'musiques/Lay All Your Love On Me - ABBA.mp3',
        Singer : 'Abba'
    },
    {
        name : 'Billie Jean',
        Image : 'images/michaeljackson.jpg',
        Song : 'musiques/Billie Jean - Michael Jackson.mp3',
        Singer : 'Michael Jackson'  
    },
    { 
        name : 'Should I Stay Or Should I Go ?',
        Image : 'images/theclash.jpg',
        Song : 'musiques/Should I Stay or Should I Go - The Clash.mp3',
        Singer : 'The Clash'
    },
    {
        name : 'Under Pressure',
        Image : 'images/queen.jpg',
        Song : 'musiques/Under Pressure - Queen.mp3',
        Singer : 'Queen'
    },
    {
      name : 'Girls Just Wanna Have Fun',
      Image : 'images/cyndilauper.jpg',
      Song : 'musiques/Girls Just Want to Have Fun - Cyndi Lauper.mp3',
      Singer : 'Cyndi Lauper'
    }
]
 
//keeping track of which song is playing and if song is playing or not
let i=0;
let flag=false;
 
 
//showing song name and image on screen
var audio = new Audio(songs_list[i].Song);
song_image.src = songs_list[i].Image
song_title.innerHTML = songs_list[i].name
song_singer.innerHTML = songs_list[i].Singer
 
//function to play/pause song
song_play.addEventListener("click", function(){
  if(flag ===false){
      audio.play()
      flag=true;
      song_play.innerHTML = '<i class="fas fa-pause fa-3x prev"></i>'; // Remplace l'icône play par l'icône pause
  }
  else{
      audio.pause()
      flag=false;
      song_play.innerHTML = '<i class="fas fa-play fa-3x prev"></i>'; // Remplace l'icône pause par l'icône play
  }
})
 
//function to play next song
song_next.addEventListener("click", function(){
   
    audio.pause()
    flag = false;
    i = i+1;
    if(i>=songs_list.length){
       
        i=0;
    }
    console.log(i)
    song_image.src = songs_list[i].Image
    song_singer.innerHTML = songs_list[i].Singer
    song_title.innerHTML = songs_list[i].name
    audio = new Audio(songs_list[i].Song)
    if(flag ===false){
        audio.play()
        flag=true;
        console.log(flag)
    }
   
})
 
//function to play previous song
song_prev.addEventListener("click", function(){
   
    audio.pause()
    flag = false;
    i = i-1;
    if(i<=0){
        i=songs_list.length-1;
        console.log(i)
    }
    song_image.src = songs_list[i].Image
    song_singer.innerHTML = songs_list[i].Singer
    song_title.innerHTML = songs_list[i].name
    audio = new Audio(songs_list[i].Song)
    if(flag ===false){
        audio.play()
        flag=true;
        console.log(flag)
    }
   
   
})



